/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;

public class SceMpegAu
extends pspAbstractMemoryMappedStructure {
    public long pts = -1L;
    public long dts = -1L;
    public int esBuffer = 0;
    public int esSize = 0;

    protected long readTimeStamp() {
        int msb = this.read32();
        int lsb = this.read32();
        return (long)msb << 32 | (long)lsb & 0xFFFFFFFFL;
    }

    protected void writeTimeStamp(long ts) {
        int msb = (int)(ts >> 32);
        int lsb = (int)ts;
        this.write32(msb);
        this.write32(lsb);
    }

    @Override
    protected void read() {
        this.pts = this.readTimeStamp();
        this.dts = this.readTimeStamp();
        this.esBuffer = this.read32();
        this.esSize = this.read32();
    }

    @Override
    protected void write() {
        this.writeTimeStamp(this.pts);
        this.writeTimeStamp(this.dts);
        this.write32(this.esBuffer);
        this.write32(this.esSize);
    }

    @Override
    public int sizeof() {
        return 24;
    }

    private static String formatTimestamp(long timestamp) {
        if (timestamp == -1L) {
            return "-1";
        }
        return String.format("0x%X", timestamp);
    }

    @Override
    public String toString() {
        return String.format("pts=%s, dts=%s, esBuffer=0x%08X, esSize=0x%X", SceMpegAu.formatTimestamp(this.pts), SceMpegAu.formatTimestamp(this.dts), this.esBuffer, this.esSize);
    }
}

